function ccg = prec_baseline(hc_L,hc_R,env_L,env_R,fs,prec_par_1,prec_par_2,maxlag_d,frame_d,frameCount,numchans,noverlap,room)
% The baseline precedence processing algorithm.
% 
%   See also PREC_

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

lengthCCG = (2*maxlag_d)+1;

% switch room
%     case '0s'
%         prec_par_2 = 0;
%     case '0_32s'
%         prec_par_2 = 0.4;
%     case '0_47s'
%         prec_par_2 = 1;
%     case '0_68s'
%         prec_par_2 = 8;
%     case '0_89s'
%         prec_par_2 = 14;
% end

G = prec_par_1;
alpha_p = prec_par_2;

envlp_L = calc_inhib(env_L,alpha_p,fs);
envlp_R = calc_inhib(env_R,alpha_p,fs);

r_L = max(hc_L-(G.*envlp_L),0);
r_R = max(hc_R-(G.*envlp_R),0);

% Cross-correlogram

ccg = zeros(lengthCCG,numchans,frameCount);

for j = 1:frameCount;
    range = (j-1)*frame_d+1:(j+noverlap-1)*frame_d;
    ccg(:,:,j) = crossCorrelogram(r_L(:,range),r_R(:,range),maxlag_d)';
end

% [EOF]
