function anfr = calc_anfr(env,fs,frame_d,frameCount)
% Calculate the auditory nerve firing rate.
% 
%   anfr = calc_anfr(env,fs,frame_d,frameCount)
% 
%   This function calculates the auditory nerve firing rate,
%   according to Palomaki et al.'s model [1].
% 
%   anfr = calc_anfr(env,fs) returns an estimate of the
%   auditory nerve firing rate from the 2-D Hilbert envelopes
%   env (with dimensions [frequency,time]) sampled at the
%   frequency FS.
% 
%   anfr = calc_anfr(env,fs,frame_d,frameCount) samples the
%   estimate of the auditory nerve firing rate every frame_d
%   sample for frameCount samples.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

if nargin > 2
    if nargin < 4
        error('Please provide a frame count')
    end
    mode = 'sampled';
else
    mode = 'unsampled';
end

numchans = size(env,1);

anfr_temp = zeros(numchans,length(env));
% smooth envelope
for i = 1:numchans;
    anfr_temp(i,:) = filter(1,[1 exp(-1000/fs*8)],env(i,:));
end
% Make negative values 0.
anfr_temp(anfr_temp < 0) = 0;
anfr_temp = anfr_temp.^0.3;

% Sample and compress
switch mode
    case 'sampled'
        anfr = anfr_temp(:,1:frame_d:frameCount*frame_d);
    case 'unsampled'
        anfr = anfr_temp;
end

% [EOF]
