function [err,field] = check_revision_profile(x,y,name)
% Check the revision profile of the results data
% 
%   [err,field] = check_revision_profile(x,y,name)
% 
%   err = check_revision_profile(x,y,name) checks the
%   results structure x for the revision profile y (named
%   name). The function assumes that the revision profile is
%   contained in all of the fields that are structures. The
%   function returns a boolean flag err indicating the error
%   state of each of these (which is false if the revision
%   profile is missing or mismatching).
% 
%   [err,field] = check_revision_profile(x,y,name) returns
%   the field names in field, such that field(err) returns
%   those fields that are missing or mismatching.
% 
%   See also BUILD_SVN_PROFILE.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

% get all structures within x
fields = fieldnames(x);
fields = fields(structfun(@isstruct,x));

% pre-allocate outputs
err = false(length(fields),1);
if nargout > 1
    field = cell(length(fields),1);
end

% check structures within x
for m = 1:length(fields)
    err(m) = compare_fields(x.(fields{m}),y,name);
    if nargout > 1
        field{m} = fields{m};
    end
end

% end of check_revision_profile()

% ----------------------------------------------------------
% Local functions:
% ----------------------------------------------------------

% ----------------------------------------------------------
% compare_fields: Look for and compare a field with an array
% ----------------------------------------------------------
function err = compare_fields(x,y,name)

err = false;

if isfield(x,name)
    % if revision profile data exists, but is different
    if ~isempty(setdiff(y,x.(name))) || ~isempty(setdiff(x.(name),y))
        err = true;
    end
else
    % if revision profile data does not exist
    err = true;
end

% [EOF]
