function IR_filename = get_IR_filename(BRIR_files,room,azimuth)
% Get the BRIR filename for a given room and azimuth
% 
%   IR_filename = get_IR_filename(BRIR_files,room,azimuth)
% 
%   IR_filename = get_IR_filename(BRIR_files,room,azimuth)
%   retrieves the filename of the impulse response at
%   azimuth for the room with tag room from the BRIR
%   structure database BRIR_FILES that is created when the
%   software loads.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

if ~(BRIR_files.(['Room_' room]).angles==azimuth)
    error(['There is no BRIR for ' num2str(azimuth) ' degrees'])
end

IR_filename = which(BRIR_files.(['Room_' room]).names{BRIR_files.(['Room_' room]).angles==azimuth});

% [EOF]
