function warper = get_warp_func(modelname,ihc_fhandle,cfs,BRIR_files,anechoic_room,fs,maxlag,maxdeg,directory)
% Get or calculate the ITD-azimuth warping function for a model
% 
%   warper = get_warp_func(modelname,ihc_fhandle,cfs,...
%       BRIR_files,anechoic_room,fs,maxlag,maxdeg,...
%       directory)
% 
% 
%   warper = get_warp_func(...) creates functions for the
%   model modelname to warp ITD to azimuth. The functions take
%   the form of a matrix, one row per frequency channel (the
%   centre frequencies of which are defined by cfs), one
%   column per degree for -maxdeg:maxdeg. Each element relates
%   this angle to its corresponding ITD value. The data is
%   returned to warper and the data are written to a structure
%   warpers which contains substructures organised by
%   modelname. The data are save to a `Functions' subdirectory
%   of directory as warpers.mat.
% 
%   The warpers are loaded by the function and the functions
%   are only created if they do not exist or the gammatone
%   filterbank parameters do not match.
% 
%   Currently, the function uses AZIMUTH2ITD and hence many of
%   these inputs are currently unused; they are provided here
%   for fututre upgrades.
% 
%   See also AZIMUTH2ITD.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

% TODO %  Develop ITD-azimuth warping method based on empircal data rather than theoretical model

if exist('warpers.mat','file')==2
    load warpers.mat
    file = true;
else
    file = false;
    warpers = struct;
    warpers.(modelname) = struct('itd_azi',0,'cfs',0);
end

try unequal_length = any(round(warpers.(modelname).cfs) ~= round(cfs)); catch, unequal_length = true; end; %#ok<CTCH>

if ~isfield(warpers,modelname) || unequal_length || ~file
    
    numchans = length(cfs);
    
    warpers.(modelname).itd_azi = zeros(numchans,2*maxdeg+1);
    
    for i = 1:numchans;
        warpers.(modelname).itd_azi(i,:) = azimuth2itd(-maxdeg:maxdeg,cfs(i))*1000;
    end
    
    warpers.(modelname).cfs = cfs;
    
    save([directory filesep 'Functions' filesep 'warpers.mat'],'warpers')
    
    warper = warpers.(modelname).itd_azi;

else
    warper = warpers.(modelname).itd_azi;
end

% [EOF]
