function ccg = prec_martin(hc_L,hc_R,env_L,env_R,fs,prec_par_1,prec_par_2,maxlag_d,frame_d,frameCount,numchans,noverlap,room)
% Precedence processing according to Martin's model.
% 
%   See also PREC_

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

% switch room
%     case '0s'
%         prec_par_2 = 0;
%     case '0_32s'
%         prec_par_2 = 0.4;
%     case '0_47s'
%         prec_par_2 = 1;
%     case '0_68s'
%         prec_par_2 = 8;
%     case '0_89s'
%         prec_par_2 = 16;
% end

G = prec_par_1;
alpha_m = prec_par_2;

envlp_L = calc_inhib(env_L,alpha_m,fs);
envlp_R = calc_inhib(env_R,alpha_m,fs);

envlp_LR = zeros(size(env_R));

for i = 1:numchans;
    % Monaural excitation envelope
    envlp_LR(i,:) = 0.5.*(envlp_L(i,:)+envlp_R(i,:));
    % Translate to make min 0
    envlp_LR(i,:) = envlp_LR(i,:)-min(envlp_LR(i,:));
    % normalise to max of 1:
    if max(envlp_LR(i,:)) ~= 0
        envlp_LR(i,:) = envlp_LR(i,:)./(max(envlp_LR(i,:)));
    end
end

% Inhibitory Signal
inhib = max(1-(G.*envlp_LR),0);

check_mex_compiled('-largeArrayDims','martin_xcorr.c')
ccg = martin_xcorr(hc_L',hc_R',frameCount,frame_d,maxlag_d,noverlap,inhib');

% [EOF]
