function azimuth = itd2azimuth(itd,f)
%  Convert ITD to azimuth
%
%   azimuth = itd2azimuth(itd,f)
%
%   azimuth = itd2azimuth(itd,f) converts the interaural
%   time difference itd (in seconds) at frequency f (in Hz)
%   to azimuth (in degrees) according to Kuhn's model [1].
% 
%   References
% 
%   [1] Kuhn, G.F. (1977), Model for the interaural time
%   differences in the azimuthal plane, The Journal of the
%   Acoustical Society of America 62, 1, 157-167.
% 
%   See also AZIMUTH2ITD, FREQ_MULTI.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:01:41 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 71 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

czero = 344;

azimuth = asind((itd*czero)/(freq_multi(f)*0.091));

% [EOF]
