function keydata = read_svn_keyword(filename,keyword)
%  Read data from a file tagged with an SVN keyword
%   
%   keydata = read_svn_keyword(filename,keyword)
%   
%   The function takes an input filename and searches that
%   file for a Subversion keyword. The data associated with
%   the keyword are returned in a character array. Keyword
%   data are placed in files automatically by Subversion at
%   each commit using the 'keyword' function. The data can
%   be useful in maintaining an audit trail, or establishing
%   the version used to generate a particular set of
%   results.
%   
%   keydata = read_svn_keyword(filename,keyword) returns a
%   string keydata containing data associated with
%   the SVN keyword in a file specified by filename.
%   
%   Filename and keyword must be strings specifying a single
%   file and keyword respectively. To read multiple files or
%   use multiple keywords, use BUILD_SVN_PROFILE instead.
%   The function returns an empty string if the keyword is
%   not found.
%   
%   See also BUILD_SVN_PROFILE.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:01:41 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 71 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

if ~ischar(filename) || ~ischar(keyword)
    error('FILENAME and KEYWORD must be char arrays')
end

keydata = '';

fid = fopen(filename); % open file
if fid == -1
    error(['read_svn_keyword: ''' filename ''' not found'])
end

tline = fgetl(fid); % read first line
while ischar(tline)
    k1 = strfind(tline,['$' keyword ':']); % find keyword
    if ~isempty(k1) % if it is found
        k2 = strfind(tline,'$'); % find the end of the keyword data
        k2 = k2(k2>k1);
        keydata = tline(k1+1:k2-2); % extract the data from the line
        tline = -1; % set tline to numeric
    else
        tline = fgetl(fid); % read next line
    end
end

fclose(fid); % close file

% [EOF]
